#ifndef _PKCS11_TC26_18_H_INCLUDED_
#define _PKCS11_TC26_18_H_INCLUDED_

#ifndef CK_VENDOR_PKCS11_RU_TEAM_TC26
#define NSSCK_VENDOR_PKCS11_RU_TEAM             0xD4321000 /* 0x80000000 | 0x54321000 */
#define CK_VENDOR_PKCS11_RU_TEAM_TC26           NSSCK_VENDOR_PKCS11_RU_TEAM
#endif // CK_VENDOR_PKCS11_RU_TEAM_TC26

#define CKK_KUZNECHIK                           (CK_VENDOR_PKCS11_RU_TEAM_TC26 |0x004)
#define CKK_KUZNYECHIK                          CKK_KUZNECHIK
#define CKK_MAGMA                               (CK_VENDOR_PKCS11_RU_TEAM_TC26 |0x005)
#define CKK_KUZNECHIK_TWIN_KEY                  (CK_VENDOR_PKCS11_RU_TEAM_TC26 |0x006)
#define CKK_KUZNYECHIK_TWIN_KEY                 CKK_KUZNECHIK_TWIN_KEY
#define CKK_MAGMA_TWIN_KEY                      (CK_VENDOR_PKCS11_RU_TEAM_TC26 |0x007)

/* GOST MECHANISMS */
#define CKM_KDF_HMAC3411_2012_256               (CK_VENDOR_PKCS11_RU_TEAM_TC26 |0x028)
// deprecated
//#define CKM_KDF_GOSTR3411_EXPORT              (CK_VENDOR_PKCS11_RU_TEAM_TC26 |0x029)
#define KDF_TREE_GOSTR3411_2012_256             (CK_VENDOR_PKCS11_RU_TEAM_TC26 |0x02A)

#define CKM_KUZNECHIK_KEXP_15_WRAP              (CK_VENDOR_PKCS11_RU_TEAM_TC26 |0x02B)
#define CKM_KUZNYECHIK_KEXP_15_WRAP             CKM_KUZNECHIK_KEXP_15_WRAP
#define CKM_MAGMA_KEXP_15_WRAP                  (CK_VENDOR_PKCS11_RU_TEAM_TC26 |0x02C)
#define CKM_KUZNECHIK_MGM                       (CK_VENDOR_PKCS11_RU_TEAM_TC26 |0x02D)
#define CKM_KUZNYECHIK_MGM                      CKM_KUZNECHIK_MGM
#define CKM_MAGMA_MGM                           (CK_VENDOR_PKCS11_RU_TEAM_TC26 |0x02E)

#define CKM_KUZNECHIK_KEY_GEN                   (CK_VENDOR_PKCS11_RU_TEAM_TC26 |0x030)
#define CKM_KUZNYECHIK_KEY_GEN                  CKM_KUZNECHIK_KEY_GEN
#define CKM_KUZNECHIK_ECB                       (CK_VENDOR_PKCS11_RU_TEAM_TC26 |0x031)
#define CKM_KUZNYECHIK_ECB                      CKM_KUZNECHIK_ECB
#define CKM_KUZNECHIK_CTR_ACPKM                 (CK_VENDOR_PKCS11_RU_TEAM_TC26 |0x032)
#define CKM_KUZNYECHIK_CTR_ACPKM                CKM_KUZNECHIK_CTR_ACPKM
#define CKM_KUZNECHIK_MAC                       (CK_VENDOR_PKCS11_RU_TEAM_TC26 |0x033)
#define CKM_KUZNYECHIK_MAC                      CKM_KUZNECHIK_MAC

#define CKM_MAGMA_KEY_GEN                       (CK_VENDOR_PKCS11_RU_TEAM_TC26 |0x034)
#define CKM_MAGMA_ECB                           (CK_VENDOR_PKCS11_RU_TEAM_TC26 |0x035)
#define CKM_MAGMA_CTR_ACPKM                     (CK_VENDOR_PKCS11_RU_TEAM_TC26 |0x036)
#define CKM_MAGMA_MAC                           (CK_VENDOR_PKCS11_RU_TEAM_TC26 |0x037)

typedef struct CK_KDF_TREE_GOST_PARAMS {
    CK_ULONG ulLabelLength;
    CK_BYTE_PTR pLabel;
    CK_ULONG ulSeedLength;
    CK_BYTE_PTR pSeed;
    CK_ULONG ulR;
    CK_ULONG ulL;
    CK_ULONG ulOffset;
} CK_KDF_TREE_GOST_PARAMS;

typedef CK_KDF_TREE_GOST_PARAMS CK_PTR CK_KDF_TREE_GOST_PARAMS_PTR;

typedef CK_GCM_PARAMS CK_MGM_PARAMS;

typedef CK_GCM_PARAMS_PTR CK_MGM_PARAMS_PTR;

#endif // _PKCS11_TC26_18_H_INCLUDED_
