/*************************************************************************
* Rutoken                                                                *
* Copyright (c) 2003-2026, Aktiv-Soft JSC. All rights reserved.          *
* Подробная информация:  http://www.rutoken.ru                           *
*------------------------------------------------------------------------*
 * В данном файле содержится объявление констант и ключей командной       *
 * строки для работы с Рутокен при помощи программы Cert2Cont.            *
 *************************************************************************/

#ifndef _CERT2CONT_H
#define _CERT2CONT_H

/* Максимальное количество контейнеров */
#define C2C_MAX_ENUM_COUNT 255

/* Параметры для экспорта открытого ключа */
#define C2C_CERT_ENCODING (X509_ASN_ENCODING | PKCS_7_ASN_ENCODING)

/* Код возврата, сигнализирующий о невозможности дальнейшего выполнения программы */
#define C2C_BAD_SELECT 0xFFFFFFFF

/* Ключ командной строки для вызова встроенной справочной системы */
#define C2C_CMD_ARG_HELP L"/?"

/* Ключ командной строки для передачи имени криптопровайдера, с которым будет производиться работа */
#define C2C_CMD_ARG_CSP L"/p"

/* Ключ командной строки для передачи имени контейнера, с которым будет производиться работа */
#define C2C_CMD_ARG_CONTAINER L"/c"

/* Ключ командной строки для передачи типа ключевой пары, с которой будет производиться работа */
#define C2C_CMD_ARG_KEYSPEC L"/k"

/* Ключ командной строки для передачи полного пути к файлу с сертификатом */
#define C2C_CMD_ARG_CERFILE L"/f"

/* Допустимое значение ключа "/k", указывает на тип ключевой пары: для ключевого обмена */
#define C2C_CMD_ARG_KEYSPEC_AT_KEYEXCHANGE L"AT_KEYEXCHANGE"

/* Допустимое значение ключа "/k", указывает на тип ключевой пары: для подписи */
#define C2C_CMD_ARG_KEYSPEC_AT_SIGNATURE L"AT_SIGNATURE"

#endif // _CERT2CONT_H