/*************************************************************************
* Rutoken                                                                *
* Copyright (c) 2003-2026, Aktiv-Soft JSC. All rights reserved.          *
* Подробная информация:  http://www.rutoken.ru                           *
*------------------------------------------------------------------------*
 * В данном файле содержится объявление следующих вспомогательных         *
 * функций для работы с Рутокен при помощи программы Cert2Cont:           *
 *  - получения хэндла ключевой пары;                                     *
 *  - получения структуры данных типа CERT_PUBLIC_KEY_INFO.               *
 *************************************************************************/

#ifndef _KEYS_H
#define _KEYS_H

/************************************************************************
 * Получить хэндл ключевой пары                                          *
 ************************************************************************/
BOOL GetCryptKey(IN HCRYPTPROV hCryptProv, // Хэндл криптопровайдера, открытый над заданным контейнером
                 IN DWORD dwPreferredKeySpec, // Требуемый тип ключевой пары
                 OUT HCRYPTKEY* hCryptKey,    // Хэндл ключевой пары
                 OUT DWORD* dwSelectedKeySpec // Тип ключевой пары
);

/************************************************************************
 * Получить структуру данных типа CERT_PUBLIC_KEY_INFO;                  *
 ************************************************************************/
BOOL GetPublicKeyBlobFromCryptProv(
    IN HCRYPTPROV hCryptProv, // Хэндл криптопровайдера, открытый над заданным контейнером
    IN DWORD dwKeySpec,               // Тип ключевой пары
    OUT PCERT_PUBLIC_KEY_INFO* pInfo, // Указатель на структуру данных типа CERT_PUBLIC_KEY_INFO
    OUT DWORD* dwInfoLen // Размер данных в структуре CERT_PUBLIC_KEY_INFO в байтах
);

#endif // _KEYS_H