# Утилита импорта der-сертификата в соответствующий ему контейнер

## Назначение
При выписывании сертификата возможна ситуация, когда на ключевом носителе создается контейнер с ключевой парой, а сертификат выдается отдельно - в виде cer-файла или текстовом виде. Утилита импорта сертификата позволяет записать такой сертификат внутрь контейнера CSP, тем самым избавляя Пользователя от необходимости всегда иметь при себе дополнительный носитель информации с файлом сертификата. `Cert2Cont` импортирует сертификаты формата X.509 в ключевые контейнеры любых CSP в Microsoft Windows.

Утилита `Cert2Cont` является FreeWare-продуктом и распространяется по принципу "как есть" без гарантий и обязательств, как явных, так и подразумеваемых.

## Особенности использования
`Cert2Cont` поддерживает два режима работы:
1. из командной строки;
2. с возможностью выбора Пользователем параметров, отсутствующих в командной строке.

`Cert2Cont` позволяет импортировать в ключевой контейнер только тот сертификат, открытый ключ которого совпадает с открытым ключом ключевой пары из контейнера. Иначе Пользователь получит сообщение об ошибке. Если в ключевом контейнере до импорта уже был сертификат, то он перезапишется при совпадении открытых ключей.

## Формат командной строки
```powershell
Cert2Cont	[/p <CSP_Name>] [/c <Container_Name>]
		[/k AT_KEYEXCHANGE|AT_SIGNATURE] [/f <Der_Cer_File_Name>]
		[/?]
	/? - вывод справки;
	/p - имя CSP, например "Aktiv ruToken CSP v1.0";
	/c - имя ключевого контейнера CSP, например
		 "{C4169872-D881-4154-8C8B-B1B2B7021BFF}";
	/k - назначение ключевой пары в контейнере CSP. Допустимо только
		 два значения параметра: "AT_KEYEXCHANGE" или "AT_SIGNATURE".
	/f - имя файла сертификата в der-кодировке.
```

ВАЖНО!!! Параметры, содержащие пробелы, должны быть указаны в командной строке в кавычках.

Пример:
```powershell
Cert2Cont.exe /p "Aktiv ruToken CSP v1.0"
              /c {C4169872-D881-4154-8C8B-B1B2B7021BFF}
              /k AT_KEYEXCHAGE /f "C:\cert.cer"
```
## Дополнительные сведения
Сертификат предварительно должен быть сохранен в файле в der-кодировке. При наличии файла сертификата в другом формате (PKCS#7 (\*.p7b), Base64 (\*.cer)), необходимо открыть этот сертификат средствами Microsoft Windows для просмотра и сохранить в der-кодировке с помощью мастера экспорта сертификатов (кнопка "Сохранить в файл"). В некоторых системах сертификаты распространяются в текстовом виде, например:

```
-----BEGIN CERTIFICATE-----
MIID2DCCA4WgAwIBAgIKEXBXbgAAAAAAcTAKBgYqhQMCAgMFADA8MQswCQYDVQQG
EwJSVTEtMCsGA1UEAx4kAEMAQQBfAEMAcgB5AHAAdABvAFAAcgBvADUAXwBKAHUA
bgBlMB4XDTA3MDcwNTE1NDA1NloXDTA4MDYwNTExMjQxM1owWzEQMA4GCSqGSIb3
DQEJARYBMTELMAkGA1UEBhMCUlUxCjAIBgNVBAgTATExCjAIBgNVBAcTATExCjAI
BgNVBAoTATExCjAIBgNVBAsTATExCjAIBgNVBAMTATEwYzAcBgYqhQMCAhMwEgYH
KoUDAgIkAAYHKoUDAgIeAQNDAARAK601R7V64H9kpEzrKfW42gg08pu+O4ukYjdG
svrzJN9jIy3kFa7h6Iet16FivJpaBDDjLyXEBxIcKMMivdtR76OCAkQwggJAMA4G
A1UdDwEB/wQEAwIE8DATBgNVHSUEDDAKBggrBgEFBQcDBDAdBgNVHQ4EFgQUcg1Z
wXP/buHfo7WnpXIOXKq14LUwcwYDVR0jBGwwaoAUNTcJ8zQ1drFofc3qEB55Lri3
x+ShQKQ+MDwxCzAJBgNVBAYTAlJVMS0wKwYDVQQDHiQAQwBBAF8AQwByAHkAcAB0
AG8AUAByAG8ANQBfAEoAdQBuAGWCEGEEalLEnr6JRG12BvlZxcgwgZ8GA1UdHwSB
lzCBlDBHoEWgQ4ZBaHR0cDovL3RvZy1wYy5ha3Rpdi5ndWFyZGFudC5ydS9DZXJ0
RW5yb2xsL0NBX0NyeXB0b1BybzVfSnVuZS5jcmwwSaBHoEWGQ2ZpbGU6Ly9cXHRv
Zy1wYy5ha3Rpdi5ndWFyZGFudC5ydVxDZXJ0RW5yb2xsXENBX0NyeXB0b1BybzVf
SnVuZS5jcmwwgeIGCCsGAQUFBwEBBIHVMIHSMGYGCCsGAQUFBzAChlpodHRwOi8v
dG9nLXBjLmFrdGl2Lmd1YXJkYW50LnJ1L0NlcnRFbnJvbGwvdG9nLXBjLmFrdGl2
Lmd1YXJkYW50LnJ1X0NBX0NyeXB0b1BybzVfSnVuZS5jcnQwaAYIKwYBBQUHMAKG
XGZpbGU6Ly9cXHRvZy1wYy5ha3Rpdi5ndWFyZGFudC5ydVxDZXJ0RW5yb2xsXHRv
Zy1wYy5ha3Rpdi5ndWFyZGFudC5ydV9DQV9DcnlwdG9Qcm81X0p1bmUuY3J0MAoG
BiqFAwICAwUAA0EAE49u5+SPrsIwAgVSerJpHj6BQCU8yiUxE+23M4thUoZEEkLn
S4ygTL/DIjf3h7/sSDKf3iFCrSYsMEG97tyrCA==
-----END CERTIFICATE-----
```

Это сертификат в Base64-кодировке. Для формирования cer-файла, необходимо сохранить в пустом текстовом файле текст сертификата и переименовать его в cer-файл. После этого файл будет открываться стандартными средствами.

При использовании утилиты без командной строки Пользователю предлагается выбрать недостающие параметры. Первым к выбору предлагается CSP. В случае выбора любого криптопровайдера КриптоПро перебираются все контейнеры КриптоПро на компьютере. Для выбора предлагаются только те из них, в которых присутствует ключевая пара без сертификата. Если в контейнере находятся две ключевые пары, то Пользователю будет предоставлен выбор, какой именно из них будет назначен импортируемый сертификат. В любом случае для импорта сертификата в контейнер открытый ключ сертификата должен совпадать с открытым ключом ключевой пары в контейнере.

Краткий алгоритм решения основной задачи:
1. Получить контекст контейнера без сертификата (`CryptAcquireContext`).
2. Прочитать файл с сертификатом.
3. Получить ключ (`HCRYPTKEY`) из контейнера (`CryptGetUserKey`).
4. Назначить ключу свойство `KP_CERTIFICATE` (`CryptSetKeyParam`).

Дополнительно можно cделать проверку на соответствие открытого ключа из сертификата открытому ключу из ключевого контейнера:
1. Получить контекст контейнера c ключевой парой.
2. Экспортировать открытый ключ (`CryptExportKey(... PUBLICKEYBLOB...)`) в буфер.
3. Прочитать сертификат из файла.
4. Получить временный контекст того же CSP (`CryptAcquireContext (pszContainer, NULL,CRYPT_VERIFYCONTEXT)`).
5. Импортировать открытый ключ сертификата во временный контекст CSP (`CryptImportPublicKeyInfo`).
6. Экспортировать открытый ключ из временного CSP (`CryptExportKey`).
7. Если полностью совпадают буферы, полученные в пунктах 2 и 6, то сертификат соответствует ключевой паре в исходном контейнере.

Исходные тексты утилиты `Cert2Cont` входят в состав Рутокен SDK.

Проект Рутокен | 2003 - 2022 (c) Компания "Актив" | www.rutoken.ru  
(c) Компания "Актив", 2003 - 2022.  
Техподдержка: hotline@rutoken.ru
