/*************************************************************************
* Rutoken                                                                *
* Copyright (c) 2003-2026, Aktiv-Soft JSC. All rights reserved.          *
* Подробная информация:  http://www.rutoken.ru                           *
*------------------------------------------------------------------------*
* Данный файл содержит объявление констант для работы с Рутокен и        *
* криптопровайдером КриптоПРО CSP через CryptoAPI на языке С             *
* Данный файл должен быть сохранён в кодировке Windows-1251 для          *
* корректной записи кириллических символов в тело сертификата            *
*************************************************************************/

#ifndef Common_H
#define Common_H

/*************************************************************************
* Включение файлов:                                                      *
*  - stdio.h - для доступа к библиотеке стандартного ввода/вывода        *
*  - locale.h - для корректного вывода кириллических символов в UTF-8    *
*  - Windows.h - для доступа к функциям Win32API                         *
*  - WinCrypt.h - для доступа к функциям CryptoAPI                       *
*  - string.h - для доступа к функциям для работы со строками            *
*  - stdlib.h - для доступа к стандартной библиотеке выделения памяти    *
*  - CSP_WinDef.h - для работы КриптоПРО CSP на *nix-платформах          *
*  - CSP_WinCrypt.h - для работы КриптоПРО CSP на *nix-платформах        *
*  - WinCryptEx.h - для доступа к определениям констант КриптоПРО CSP    *
*************************************************************************/

#include <stdbool.h>
#include <stdio.h>
#include <locale.h>
// clang-format off
#ifdef _WIN32
#   include <Windows.h>
#   include <WinCrypt.h>
#else
#   include <string.h>
#   include <stdlib.h>
#   include <CSP_WinDef.h>
#   include <CSP_WinCrypt.h>
#endif
// clang-format on
#include <WinCryptEx.h>

/************************************************************************
* Макросы                                                               *
************************************************************************/

/* Вычисление размера массива */
#define GetArraySize(a) sizeof(a) / sizeof(a[0])

/* Максимальное количество установленных криптопровайдеров */
#define MAX_PROV 100
/* Максимальное количество контейнеров на токене */
#define MAX_CONT 50

/************************************************************************
* Имена и типы криптопровайдеров                                        *
************************************************************************/

/* Криптопровайдер "Crypto-Pro GOST R 34.10-2001 Cryptographic Service Provider" */
#define CRYPTOPRO_2001_PROV_A CP_GR3410_2001_PROV_A

/* Криптопровайдер "Crypto-Pro GOST R 34.10-2001 Cryptographic Service Provider" */
#define CRYPTOPRO_2001_PROV_W CP_GR3410_2001_PROV_W

/* Криптопровайдер "GOST R 34.10-2001 Rutoken CSP" для ФКН */
#define CRYPTOPRO_FKN_2001_PROV_A CP_KC1_GR3410_2001_RUTOKEN_PROV_A

/* Криптопровайдер "GOST R 34.10-2001 Rutoken CSP" для ФКН */
#define CRYPTOPRO_FKN_2001_PROV_W CP_KC1_GR3410_2001_RUTOKEN_PROV_W

/* Тип криптопровайдера КриптоПРО CSP для создания ключей алгоритма ГОСТ Р 34.10-2001 */
#define CRYPTOPRO_2001_PROV_TYPE PROV_GOST_2001_DH

/* Криптопровайдер "Crypto-Pro GOST R 34.10-2012 Cryptographic Service Provider" */
#define CRYPTOPRO_2012_256_PROV_A CP_GR3410_2012_PROV_A

/* Криптопровайдер "Crypto-Pro GOST R 34.10-2012 Cryptographic Service Provider" */
#define CRYPTOPRO_2012_256_PROV_W CAT_L(CP_GR3410_2012_PROV_A)

/* Криптопровайдер "Crypto-Pro GOST R 34.10-2012 KC1 CSP" для ФКН */
#define CRYPTOPRO_FKN_2012_256_PROV_A CP_KC1_GR3410_2012_PROV_A

/* Криптопровайдер "Crypto-Pro GOST R 34.10-2012 KC1 CSP" для ФКН */
#define CRYPTOPRO_FKN_2012_256_PROV_W CAT_L(CP_KC1_GR3410_2012_PROV_A)

/* Тип криптопровайдера КриптоПРО CSP для создания ключей алгоритма ГОСТ Р 34.10-2012 длины 256 бит */
#define CRYPTOPRO_2012_256_PROV_TYPE PROV_GOST_2012_256

/* Криптопровайдер "Crypto-Pro GOST R 34.10-2012 Strong Cryptographic Service Provider" */
#define CRYPTOPRO_2012_512_PROV_A CP_GR3410_2012_STRONG_PROV_A

/* Криптопровайдер "Crypto-Pro GOST R 34.10-2012 Strong Cryptographic Service Provider" */
#define CRYPTOPRO_2012_512_PROV_W CAT_L(CP_GR3410_2012_STRONG_PROV_A)

/* Криптопровайдер "Crypto-Pro GOST R 34.10-2012 KC1 Strong CSP" для ФКН */
#define CRYPTOPRO_FKN_2012_512_PROV_A CP_KC1_GR3410_2012_STRONG_PROV_A

/* Криптопровайдер "Crypto-Pro GOST R 34.10-2012 KC1 Strong CSP" для ФКН */
#define CRYPTOPRO_FKN_2012_512_PROV_W CAT_L(CP_KC1_GR3410_2012_STRONG_PROV_A)

/* Тип криптопровайдера КриптоПРО CSP для создания ключей алгоритма ГОСТ Р 34.10-2012 длины 512 бит */
#define CRYPTOPRO_2012_512_PROV_TYPE PROV_GOST_2012_512

/* Тип создаваемой ключевой пары в контейнерах */
#define KEYPAIR_TYPE AT_KEYEXCHANGE   

/* Тип создаваемой ключевой пары для примеров SignVerify, SignVerifyPKCS7, SignVerifySilent */
//#define KEYPAIR_TYPE AT_SIGNATURE

/************************************************************************
* Алгоритмы криптопровайдера                                            *
************************************************************************/

/* Алгоритм цифровой подписи ГОСТ Р 34.10-2001 */
#define OID_GOST3410_2001 szOID_CP_GOST_R3411_R3410EL

/* Алгоритм цифровой подписи ГОСТ Р 34.10-2012 для ключей длины 256 бит */
#define OID_GOST3410_2012_256 szOID_CP_GOST_R3411_12_256_R3410

/* Алгоритм цифровой подписи ГОСТ Р 34.10-2012 для ключей длины 512 бит */
#define OID_GOST3410_2012_512 szOID_CP_GOST_R3411_12_512_R3410

/* Функция хэширования ГОСТ Р 34.11-94 */
#define OID_GOST3411_2001 szOID_CP_GOST_R3411

/* Функция хэширования ГОСТ Р 34.11-2012, длина выхода 256 бит */
#define OID_GOST3411_2012_256 szOID_CP_GOST_R3411_12_256

/* Функция хэширования ГОСТ Р 34.11-2012, длина выхода 512 бит */
#define OID_GOST3411_2012_512 szOID_CP_GOST_R3411_12_512

/* Идентификатор алгоритма хэширования ГОСТ Р 34.11-94 */
#define ALG_GOST3411_2001 CALG_GR3411

/* Параметры ГОСТ Р 34.11-94 по умолчанию */
#define GOST3411_2001_PARAMS OID_HashVerbaO

/* Идентификатор алгоритма хэширования ГОСТ Р 34.11-2012, длина выхода 256 бит */
#define ALG_GOST3411_2012_256 CALG_GR3411_2012_256

/* Идентификатор алгоритма хэширования ГОСТ Р 34.11-2012, длина выхода 512 бит */
#define ALG_GOST3411_2012_512 CALG_GR3411_2012_512

/* Тип кодирования */
#define ENC_TYPE (X509_ASN_ENCODING | PKCS_7_ASN_ENCODING)

/************************************************************************
* Вспомогательные переменные                                            *
************************************************************************/

/* DEMO имя ключевого контейнера */
static LPCWSTR CONT_NAME_2001_W = L"RUTOKEN DEMO CONTAINER GOST34.10-2001";
static LPCWSTR CONT_NAME_2012_256_W = L"RUTOKEN DEMO CONTAINER GOST34.10-2012-256";
static LPCWSTR CONT_NAME_2012_512_W = L"RUTOKEN DEMO CONTAINER GOST34.10-2012-512";
static LPCSTR FQCN_CONT_NAME_2001 = "\\\\.\\Aktiv Rutoken ECP 0\\RUTOKEN DEMO CONTAINER GOST34.10-2001";
static LPCSTR FQCN_CONT_NAME_2012_256 = "\\\\.\\Aktiv Rutoken ECP 0\\RUTOKEN DEMO CONTAINER GOST34.10-2012-256";
static LPCSTR FQCN_CONT_NAME_2012_512 = "\\\\.\\Aktiv Rutoken ECP 0\\RUTOKEN DEMO CONTAINER GOST34.10-2012-512";

/* DEMO PIN-код Пользователя Рутокен */
static BYTE USER_PIN[] = "12345678";

/* DEMO поля сертификата */
static LPCWSTR SUBJECT_NAME_2001_W = L"CN=TestCert-2001, L=Moscow, O=AktivCo, E=hotline@rutoken.ru, T=Test";
static LPCWSTR SUBJECT_NAME_2012_256_W = L"CN=TestCert-2012-256, L=Moscow, O=AktivCo, E=hotline@rutoken.ru, T=Test";
static LPCWSTR SUBJECT_NAME_2012_512_W = L"CN=TestCert-2012-512, L=Moscow, O=AktivCo, E=hotline@rutoken.ru, T=Test";

/* Имя субъекта в сертификате */
static LPCWSTR CERT_SUBJECT_NAME_2001_W = L"TestCert-2001";
static LPCWSTR CERT_SUBJECT_NAME_2012_256_W = L"TestCert-2012-256";
static LPCWSTR CERT_SUBJECT_NAME_2012_512_W = L"TestCert-2012-512";

static BYTE KEY_USAGE = CERT_DIGITAL_SIGNATURE_KEY_USAGE | CERT_NON_REPUDIATION_KEY_USAGE;
static const char* EXT_KEY_USAGE[] = { szOID_PKIX_KP_CLIENT_AUTH };

/* DEMO сообщение для подписи */
static BYTE* MSG_TO_SIGN = (BYTE*)"An example of plaintext to sign";

#endif //PKCS11_COMMON_H
