# Библиотека PKCS#11

## Введение
В данной директории хранятся библиотека rtPKCS11ECP, собранная для различных платформ, заголовочные файлы библиотеки rtPKCS11ECP, оригинал стандарта PKCS#11 и кроссплатформенные примеры работы с Рутокен с использованием библиотеки PKCS#11 на языке C.

Примеры PKCS#11 позволяют продемонстрировать функциональность токенов через интерфейс PKCS#11. Логически примеры разделены на группы:
* `Standard` (используется исключительно интерфейс, описанный в стандарте PKCS#11 v2.40);
* `Extended` (дополнительно используются функции расширения общего назначения);
* `PKIExtensions` (дополнительно используются функции расширения, предназначенные для поддержки PKI).

Для выполнения некоторых примеров требуется выполнение предусловий: наличие объектов на токене или данных в файловой системе. Некоторые примеры самодостаточны и выполняются без предусловий.

## Описание примеров
Следующие примеры являются самодостаточными:
* `Info` -- получение информации о доступных слотах и подключенных токенах;
* `InitToken` -- пример инициализации токена в первом доступном слоте;
* `GeneralPurpose` -- пример использования функций расширения стандарта PKCS#11 общего назначения;
* `WaitForSlotEvent` -- пример обработки событий подключения и отключения токена; является интерактивным: требует ввода с клавиатуры и активации или деактивации тестируемого устройства;
* `SigVerGOST34.11-*-HMAC` -- пример генерации HMAC с использованием алгоритмов хэширования ГОСТ 34.11;
* `DigestGOST34.11-*`, `DigestUpdateGOST34.11-*` -- пример использования алгоритмов хэширования ГОСТ 34.11;
* `EncDecGOST28147-89-CBC` -- пример выполнения блочного шифрования ГОСТ 28147-89 в режиме CBC.
* `ManageFlash` -- пример управления разделами флеш-диска на токене Рутокен ЭЦП 2.0 Flash.

Следующие примеры требуют предварительной генерации ключей на токене:
* `SigVerGOST34.10-*`, `SigVerRSA`, `SigVerECDSA` -- пример выполнения и проверки цифровой подписи с предварительным вычислением хэша от документа;
* `SignGOST34.10-*WithHash`, `SignRSAWithHash` -- пример выполнения цифровой подписи с одновременным вычислением хэша от документа;
* `SigVerUpdateGOST34.10-2012-256WithHash`, `SigVerUpdateRSAWithHash` -- пример выполнения и проверки поточной цифровой подписи с одновременным вычислением хэша от документа;
* `VKO-GOST34.10-*` -- пример выполнения алгоритма согласования ключей по алгоритму VKO ГОСТ 34.10;
* `EncDecEcb` -- пример выполнения блочного шифрования ГОСТ 34.12-2018 с длиной блока 128 бит (Кузнечик) в режиме ECB;
* `EncDecStream` -- пример выполнения поточного шифрования ГОСТ 34.12-2018 с длиной блока 128 бит (Кузнечик);
* `EncDecRSA` -- пример выполнения шифрования алгоритмом RSA;
* `SigVerMac` -- пример подсчета имитовставки ГОСТ 34.12-2018 с длиной блока 128 бит (Кузнечик) MAC.

Генерация ключей на токене выполняется следующими примерами:
* `CreateGOST34.10-*`
* `CreateFor*`
* `CreateRSA`
* `CreateECDSA`

Для выполнения примеров, соответствующих определенному криптоалгоритму, необходимо создать ключ/ключи того же криптоалгоритма.

По окончании работы с примерами сгенерированные ключи можно удалить с токена при помощи примеров:
* `DeleteGOST34.10-*`
* `DeleteEncDecSigVer`
* `DeleteRSA`
* `DeleteECDSA`

Логическую цепочку составляют примеры по управлению DATA-объектами на токене: `CreateDataObject`, `FindDataObject` и `DeleteDataObject`.

Для корректной работы примеров `Journal`, `JournalParse`, демонстрирующих возможности использования журнала операций на токене, необходимо выполнить хотя бы одну операцию цифровой подписи алгоритмом ГОСТ 34.10, например, при помощи примера `SigVerGOST34.10-2001`.

Использование примеров группы `PKIExtensions` следует начинать с генерации запроса на сертификат при помощи примера `CreateCSR-PKCS10-*`, после чего выписывать сертификат и импортировать его на токен при помощи примера `ImportCertificate-*`. Для выписывания сертификата по запросу можно воспользоваться сервисами Тестового УЦ Крипто Про (http://testgost2012.cryptopro.ru/certsrv/ или http://cryptopro.ru/certsrv/) или воспользоваться утилитой `openssl`.

Пример последовательности команд для выпуска сертификата `cert_2001.cer` по запросу `req_2001.pem` удостоверяющим центром с сертификатом `cacert.pem` и приватным ключом `cakey.pem` при помощи `openssl` и модуля `rtengine`:
```bash
OPENSSL_CONF=openssl.cnf openssl x509 -engine rtengine -req -in req_2001.pem -CA cacert.pem -CAkey cakey.pem -CAcreateserial -days 500 -outform der -out cert_2001.cer
```

В результате выполнения команды будет создан файл сертификата `cert_2001.cer`, который затем будет импортирован на токен при помощи примера `ImportCertificate-GOST34.10-2001`.

Для примеров `ImportCertificate-GOST34.10-2012-256` и `ImportCertificate-GOST34.10-2012-512` файл сертификата должен иметь имя `cert_2012-256.cer` и `cert_2012-512.cer`, соответственно.

Для работы примеров `VerifyPKCS7` и `VerifyPKCS7Detached` сертификат тестового УЦ в формате DER должен быть доступен в директории примеров под именем `CA_cert.cer`.

Следующие примеры `PKIExtensions` зависят от наличия импортированного сертификата на токене:
* `GetCertificateInfo-*` -- получение информации о соответствующем сертификате.
* `ExportCertificateAsPEM` -- сохранение сертификата в формате PEM.
* `SignPKCS7-GOST34.10-*` -- подпись данных соответствующей ключевой парой в формате PKCS#7. Данные подписи сохраняются в директории примеров в файле `cms_data`.
* `SignPKCS7Detached-GOST34.10-*` -- подпись данных соответствующей ключевой парой в формате PKCS#7 без сохранения исходного сообщения. Данные подписи сохраняются в директории примеров в файле `cms_detached_data`.
* `VerifyPKCS7` -- проверка подписи в формате PKCS#7. Подпись для проверки считывается из файла `cms_data`, сертификат УЦ считывается из файла `CA_cert.cer`.
* `VerifyPKCS7Detached` -- проверка подписи в формате PKCS#7 без исходного сообщения. Подпись для проверки считывается из файла `cms_detached_data`, сертификат УЦ считывается из файла `CA_cert.cer`.

По окончании работы с примерами группы `PKIExtensions` объекты, сгенерированные на токене, можно удалить при помощи примеров `DeleteObjects-GOST34.10-*`.

## Лицензионные обязательства
Официальное название PKCS#11 -- "RSA Security Inc. PKCS #11 Cryptographic Token Interface (Cryptoki)".

Исходный код библиотеки rtPKCS11ECP использует официальные заголовки PKCS#11 версии 2.40 и поэтому "является производным от RSA Security Inc. PKCS #11 Cryptographic Token Interface (Cryptoki)".

Библиотека rtPKCS11ECP содержит программное обеспечение, разработанное OpenSSL Project для использования в OpenSSL Toolkit. (http://www.openssl.org/). Лицензия данного программного обеспечения размещена в файле LICENSE_OPENSSL.

Библиотека rtPKCS11ECP содержит программное обеспечение, написанное Eric Young (eay@cryptsoft.com).

Библиотека rtPKCS11ECP содержит программное обеспечение, написанное Tim Hudson (tjh@cryptsoft.com).

## License issues
The official name for PKCS#11 is "RSA Security Inc. PKCS #11 Cryptographic Token Interface (Cryptoki)".

rtPKCS11ECP library source code includes the official header files (version 2.40) and thus is "derived from the RSA Security Inc. PKCS #11 Cryptographic Token Interface (Cryptoki)".

rtPKCS11ECP library includes software developed by the OpenSSL Project for use in the OpenSSL Toolkit. (http://www.openssl.org/). License of this software can be found in LICENSE_OPENSSL file in the same directory as this file.

rtPKCS11ECP library includes cryptographic software written by Eric Young (eay@cryptsoft.com).

rtPKCS11ECP library includes software written by Tim Hudson (tjh@cryptsoft.com).
