#	Rutoken PKCS#11 Spy installation script
#	
#	Keep in folder with rtpkcs11ecp.framework. Need to launch as root.
#
#	Usage:
#
#	Possible arguments are:
#	
#	1. -l/--lib specifies path rtpkcs11ecp.framework. If not set then default
#		value "/Library/Aktiv Co/Rutoken ECP/rtpkcs11ecp.framework" used.
#
#	2. -u/--uninstall deletes Rutoken PKCS#11 Spy. 
#
#	3. -o/--out specifies path to log file. Default value is /Library/Logs/rutoken/pkcs11spy/log.log
#
while [[ $# -gt 0 ]] 	#	Parse arguments
do
	key="$1" 
	case $key in 
		-l |--lib)
			oldPath="$2"
			shift 2
		;;
		-o |--out)
			output="$2"
			shift 2
		;;
		-u |--uninstall)
			uninst=true
			shift
		;;
		*)
			shift
		;;
	esac
done

if [ -z "$oldPath" ] # rtpkcs11ecp.framework oldPath is empty
then
	oldPath="/Library/Aktiv Co/Rutoken ECP/rtpkcs11ecp.framework"
	newPath="/Library/Aktiv Co/Rutoken ECP/rtpkcs11ecp_origin.framework"
else
	newPath="$(dirname "$oldPath")/rtpkcs11ecp_origin.framework"
fi

if [ -z "$output" ] # path to log file is empty
then
	output="/Library/Logs/rutoken/pkcs11spy/log.log"
fi


if [ -z $uninst ] # Installing
then
	plistPath="/Library/Preferences/ru.rutoken.pkcs11spy.plist"	#	Create plist in /Library/Preferences/
	var=$(touch $plistPath)

	if [ $? == 0 ] #success
	then
		plistData="
					<?xml version="1.0" encoding="UTF-8"?>
					<!DOCTYPE >
					<plist version="1.0">
					<dict>
						<key>RT_PKCS11SPY</key>
						<string>$newPath/rtpkcs11ecp</string>
						<key>RT_PKCS11SPY_OUTPUT</key>
						<string>$output</string>
					</dict>
					</plist>
				  "
		echo $plistData > $plistPath
	else
		echo "Property list file can't be created. Please run this as root!"
		exit 1
	fi

	if [ -f "$newPath" ]
	then
		echo "Rutoken PKCS#11 Spy is already installed. Please, uninstall it first."
		exit 2
	fi

	var=$(mv -f "$oldPath" "$newPath")	#	Rename rtpkcs11ecp.framework to rtpkcs11ecp_origin.framework

	if [ $? -gt "0" ] #failure
	then
		echo "Library \"$oldPath\" can't be renamed!"
		exit 3
	fi

	spyPath="$(dirname "$0")/rtpkcs11-spy.framework" 	#	Copy Rutoken PKCS#11 SPY to destination folder
	var=$(cp -PR "$spyPath" "$oldPath")
	var=$(mv -f "$oldPath/rtpkcs11-spy" "$oldPath/rtpkcs11ecp")

	if [ $? -ne "0" ] #failure
	then
		echo "Library \"$spyPath\" can't be copied! Aborting changes."
		var=$(mv -f "$newPath" "$oldPath")
		exit 4
	fi

	folder="$(dirname $output)"
	if [ ! -d "$folder" ]
	then
		var="$(mkdir -p $folder)"
	fi
	var="$(touch $output)"
	var="$(chmod 777 $output)"

	echo "Rutoken PKCS#11 Spy has been successfully installed! Restart to let changes take effect."

else # uninstall
	spyPath="$(dirname "$0")/rtpkcs11-spy.framework" # path of original spy
	var=$(mv -f "$oldPath/rtpkcs11ecp" "$oldPath/rtpkcs11-spy")
	var="$(diff -r "$oldPath" "$spyPath")"

	if [ "$var" ]
	then
		echo "Rutoken PKCS#11 Spy is not installed!"
		exit 5
	fi

	var="$(rm -rf "$oldPath")" 	#	Delete Rutoken PKCS#11 SPY

	if [ $? -gt "0" ]
	then
		echo "Library \"$oldPath\" can't be removed!"
		exit 6
	fi

	var=$(mv -f "$newPath" "$oldPath")	#	Rename rtpkcs11ecp_origin.framework to rtpkcs11ecp.framework

	if [ $? -gt "0" ] #failure
	then
		echo "Library \"$newPath\" can't be renamed!"
		exit 8
	fi

	plistPath="/Library/Preferences/ru.rutoken.pkcs11spy.plist"
	var=$(rm $plistPath)

	echo "Rutoken PKCS#11 Spy has been successfully removed! Restart to let changes take effect."
fi