/*************************************************************************
* Rutoken                                                                *
* Copyright (c) 2003-2026, Aktiv-Soft JSC. All rights reserved.          *
* Подробная информация:  http://www.rutoken.ru                           *
*------------------------------------------------------------------------*
 * Данный пример демонстрирует генерацию ключевой пары на токене с        *
 * помощью pkicore. В консоль выводится идентификатор сгенерированной     *
 * ключевой пары.                                                         *
 *************************************************************************/

#include <common.h>

using namespace std;
using namespace rutoken::pkicore;

int main() {
    try {
        cout << boolalpha;

        /**********************************************************************
         * Инициализируем pkicore, передав путь до директории с библиотекой    *
         * rtPKCS11ECP.                                                        *
         **********************************************************************/
        rutoken::pkicore::initialize(".");
        SCOPE_EXIT() {
            /**********************************************************************
             * Завершаем работу с pkicore при выходе из текущего блока.            *
             **********************************************************************/
            rutoken::pkicore::deinitialize();
        };

        /**********************************************************************
         * Получаем список подключенных устройств и продолжаем работу с первым *
         * доступным устройством.                                              *
         **********************************************************************/
        auto devices = Pkcs11Device::enumerate();
        if (devices.empty()) {
            throw runtime_error("There must be at least one device connected");
        }

        auto device = move(devices.front());

        /**********************************************************************
         * Аутентифицируемся на устройстве.                                    *
         **********************************************************************/
        device.login("12345678");
        SCOPE_EXIT(&device) {
            /**********************************************************************
             * Сбрасываем права доступа при выходе из текущего блока.              *
             **********************************************************************/
            device.logout();
        };

        /**********************************************************************
         * Генерируем ключевую пару ГОСТ 34.10 2012 с ключом длиной 512 бит    *
         * на устройстве.                                                      *
         **********************************************************************/
        auto key = device.generateKeyPair(Pkcs11Device::Gost34102012_512KeyGenParams());

        /**********************************************************************
         * Выводим hex-кодированный идентификатор ключа.                       *
         **********************************************************************/
        auto id = toHex(key.getId());
        cout << "Key pair " << id << " has been generated" << endl;
    } catch (const exception& e) {
        cerr << e.what() << endl;
        return 1;
    }

    return 0;
}
