#ifndef RTFL_UTILS_H
#define RTFL_UTILS_H

#include "rtflash-utils-status.h"

#ifdef __cplusplus
extern "C" {
#endif

/// Тип элемента слепка ПК.
typedef char rtfl_utils_PcSnapshotElement;

/// Слепок персонального компьютера (ПК) - символьная последовательность, составленная на основе
/// hardware-характеристик ПК, в определенном формате.
typedef struct rtfl_utils_PcSnapshot {
        uint8_t size;                      ///< Размер слепка.
        rtfl_utils_PcSnapshotElement* ptr; ///< Указатель на слепок ПК.
} rtfl_utils_PcSnapshot;

/// Формирует слепок ПК.
/// \param outPcSnapshot - указатель на выходной слепок ПК. Должен быть ненулевым.
/// \attention После использования полученного слепка outPcSnapshot необходимо передать в функцию
/// #rtfl_utils_pc_snapshot_destroy.
/// \return Код возврата.
RTFL_UTILS_API rtfl_utils_StatusCode
rtfl_utils_pc_snapshot(rtfl_utils_PcSnapshot* const outPcSnapshot);

/// Очищает слепок ПК, полученный с помощью функции #rtfl_utils_pc_snapshot.
/// \param pcSnapshot - указатель на слепок ПК. Должен быть ненулевым.
/// \return Код возврата.
RTFL_UTILS_API rtfl_utils_StatusCode
rtfl_utils_pc_snapshot_destroy(rtfl_utils_PcSnapshot* const pcSnapshot);

#ifdef __cplusplus
}
#endif

#endif // RTFL_UTILS_H
