/*************************************************************************
* Rutoken                                                                *
* Copyright (c) 2003-2026, Aktiv-Soft JSC. All rights reserved.          *
* Подробная информация:  http://www.rutoken.ru                           *
*************************************************************************/

/**************************************************************************
 * Данный файл содержит объявления макросов и функций для демонстрации    *
 * работы с Рутокен Flash 3.0 при помощи библиотеки rtflash на языке C    *
 **************************************************************************/

#ifndef RTFLASHSAMPLES_COMMON_H
#define RTFLASHSAMPLES_COMMON_H

/**************************************************************************
 * Включение файлов:                                                      *
 *  - rtflash-utils.h - для вычисления слепка ПК;                         *
 *  - rtflash.h - для доступа к функциям rtflash;                         *
 *  - stdio.h - для доступа к библиотеке стандартного ввода/вывода;       *
 *  - stdlib.h - для доступа к функциям стандартной библиотеки языка С.   *
 **************************************************************************/

#include <rtflash-utils.h>
#include <rtflash.h>
#include <stdio.h>
#include <stdlib.h>

/**************************************************************************
 * Макрос вычисления количества элементов в массиве                       *
 **************************************************************************/
#define SIZE_OF(array) (sizeof((array)) / sizeof((array)[0]))

/**************************************************************************
 * Макрос проверки ошибки. Если произошла ошибка, то выводится сообщение  *
 * и выполняется переход на переданную метку                              *
 *                                                                        *
 * ВАЖНО: макрос не изменяет exitCode — это обязанность вызывающего кода  *
 **************************************************************************/
#define EXPECT(expectation, label)                                                                          \
    do {                                                                                                    \
        if (!(expectation)) {                                                                               \
            printf("Expectation is failed: %s. \nLocation: %s:%d (%s)\n", #expectation, __FILE__, __LINE__, \
                   __FUNCTION__);                                                                           \
            goto label;                                                                                     \
        }                                                                                                   \
    } while (0)

/**************************************************************************
 * Макрос проверки возвращаемого значения функции rtflash.                *
 * Если код возврата не совпадает с #RTFLASH_ST_OK, то выводится код и    *
 * краткое описание ошибки, после чего выполняется переход на метку.      *
 *                                                                        *
 * ВАЖНО: макрос не изменяет exitCode — это обязанность вызывающего кода  *
 **************************************************************************/
#define ST_OK_CHECK(function, label)                                          \
    do {                                                                      \
        const rtflash_StatusCode stCode = (function);                         \
        printf("line:%d call %s: ", __LINE__, #function);                     \
                                                                              \
        if (stCode == RTFLASH_ST_OK) {                                        \
            printf("ok\n");                                                   \
            break;                                                            \
        }                                                                     \
        printf("\n\tStatus code: %u\n", stCode);                              \
        const char* outDescr = RTFLASH_NULL_PTR;                              \
        if (rtflash_status_description(stCode, &outDescr) == RTFLASH_ST_OK) { \
            printf("\tDescription: %s\n", outDescr);                          \
        }                                                                     \
                                                                              \
        goto label;                                                           \
    } while (0)

/**************************************************************************
 * Макрос проверки возвращаемого значения функции rtflash-utils.          *
 * Если код возврата не совпадает с #RTFL_UTILS_ST_OK, то выводится код и *
 * краткое описание ошибки, после чего выполняется переход на метку.      *
 *                                                                        *
 * ВАЖНО: макрос не изменяет exitCode — это обязанность вызывающего кода  *
 **************************************************************************/
#define UTILS_ST_OK_CHECK(function, label)                                          \
    do {                                                                            \
        rtfl_utils_StatusCode stCode = (function);                                  \
        printf("line:%d call %s: ", __LINE__, #function);                           \
                                                                                    \
        if (stCode == RTFL_UTILS_ST_OK) {                                           \
            printf("ok\n");                                                         \
            break;                                                                  \
        }                                                                           \
                                                                                    \
        printf("\n\tStatus code: %u\n", stCode);                                    \
        const char* outDescr = RTFLASH_NULL_PTR;                                    \
        if (rtfl_utils_status_description(stCode, &outDescr) == RTFL_UTILS_ST_OK) { \
            printf("\tDescription: %s\n", outDescr);                                \
        }                                                                           \
                                                                                    \
        goto label;                                                                 \
    } while (0)
#endif // RTFLASHSAMPLES_COMMON_H
