/*************************************************************************
* Rutoken                                                                *
* Copyright (c) 2003-2026, Aktiv-Soft JSC. All rights reserved.          *
* Подробная информация:  http://www.rutoken.ru                           *
*************************************************************************/

/**************************************************************************
 * Пример работы с Рутокен Flash 3.0 при помощи библиотеки rtflash на     *
 * языке C                                                                *
 **************************************************************************
 * Запись информации о компьютере в журнал СБ                             *
 **************************************************************************
 * Выполняемые действия:                                                  *
 *  - поиск первого доступного Рутокен Flash 3.0;                         *
 *  - установка соединения с Рутокен Flash 3.0;                           *
 *  - запись информации о компьютере в журнал СБ.                         *
 **************************************************************************
 * Данный пример является самодостаточным.                                *
 **************************************************************************/

#include "common.h"

int main(void) {
    int exitCode = EXIT_FAILURE;

    rtflash_TokenSerial* tokensSerialArray = RTFLASH_NULL_PTR; // Массив серийных номеров токенов
    size_t tokensSerialArrayLength = 0; // Размер массива серийных номеров токенов
    bool isTokensExists = false;        // Флаг, что список токенов не пуст

    rtflash_Token token = RTFLASH_NULL_PTR; // Объект токен
    bool isSupport = false;                 // Флаг, поддерживается ли токен
    size_t i = 0;                           // Счетчик

    rtflash_String userName;   // Имя пользователя в системе
    rtflash_String domainName; // Доменное имя
    rtflash_String osVersion;  // Версия ОС
    rtflash_String deviceName; // Имя устройства
    rtflash_UnixTime time;     // Unix timestamp
    rtflash_PcInfo pcInfo;     // Информация о ПК

    /**************************************************************************
     * Получение массива серийных номеров подключенных токенов                *
     **************************************************************************/

    ST_OK_CHECK(rtflash_create_token_list(&tokensSerialArray, &tokensSerialArrayLength), cleanup);
    // Проверяем, что функция выполнилась успешно и массив не пуст
    isTokensExists = tokensSerialArray != RTFLASH_NULL_PTR && tokensSerialArrayLength > 0;
    EXPECT(isTokensExists, cleanup);

    /**************************************************************************
     * Поиск первого поддерживаемого библиотекой токена                       *
     **************************************************************************/
    // Проходим по всему массиву токенов
    for (i = 0; i < tokensSerialArrayLength; ++i) {
        // Создаем объект токена
        ST_OK_CHECK(rtflash_create_token(tokensSerialArray[i], &token), cleanup);
        // Проверяем, поддерживается ли этот токен
        ST_OK_CHECK(rtflash_is_token_supported(token, &isSupport), cleanup);
        // Если токен поддерживается, завершаем цикл
        if (isSupport)
            break;
        // Иначе уничтожаем объект с неподдерживаемым токеном и переходим к следующему
        rtflash_destroy_token(&token);
    }

    // Если нет поддерживаемых токенов
    if (!isSupport) {
        // Выводим сообщение: "Не найдено поддерживаемых токенов"
        printf("No supported tokens found.\n");
        goto cleanup;
    }

    /**************************************************************************
     * Создание структуры, содержащей информацию о текущем компьютере.        *
     * Получение этих данных выходит за пределы функционала библиотеки,       *
     * поэтому в рамках примера она генерируется в коде программы             *
     **************************************************************************/

    userName = (rtflash_String){ 4, "User" };
    domainName = (rtflash_String){ 6, "Domain" };
    osVersion = (rtflash_String){ 19, "157.000.45654.55141" };
    deviceName = (rtflash_String){ 10, "DeviceName" };
    time = 1761638435;

    pcInfo = (rtflash_PcInfo){ userName, domainName, osVersion, deviceName, time };

    /**************************************************************************
     * Запись в журнал структуры, содержащей информацию о текущем компьютере  *
     **************************************************************************/

    ST_OK_CHECK(rtflash_add_pc_info_to_journal(token, &pcInfo), cleanup);
    // Выводим сообщение: "Информация о ПК была записана в журнал."
    printf("PC information was written to journal.\n");

    // Успешно завершаем работу программы
    exitCode = EXIT_SUCCESS;

cleanup:
    // Очищаем память, занятую массивом серийных номеров токенов
    if (tokensSerialArray != RTFLASH_NULL_PTR)
        rtflash_destroy_token_list(&tokensSerialArray);
    // Уничтожаем объект токена
    if (token != RTFLASH_NULL_PTR)
        rtflash_destroy_token(&token);
    printf("Cleanup finished.\n");
    if (exitCode == EXIT_SUCCESS)
        printf("Sample completed successfully!\n");
    return exitCode;
}