/*************************************************************************
* Rutoken                                                                *
* Copyright (c) 2003-2026, Aktiv-Soft JSC. All rights reserved.          *
* Подробная информация:  http://www.rutoken.ru                           *
*************************************************************************/

/**************************************************************************
 * Пример работы с Рутокен Flash 3.0 при помощи библиотеки rtflash на     *
 * языке C                                                                *
 **************************************************************************
 * Вычисление слепка ПК                                                   *
 **************************************************************************
 * Выполняемые действия:                                                  *
 * - вычисление слепка ПК;                                                *
 * - вывод слепка ПК в консоль в двух форматах.                           *
 **************************************************************************
 * Данный пример является самодостаточным.                                *
 **************************************************************************/

#include "common.h"

/**************************************************************************
 * Функция вывода на экран слепка ПК в бинарном формате в линии по 16 байт*
 **************************************************************************
 *  rtfl_utils_PcSnapshot snapshot - Слепок ПК                            *
 **************************************************************************/
void printSnapshotHex(const rtfl_utils_PcSnapshot snapshot) {
    int line = 1; // Счетчик линий
    uint8_t i = 0;

    // Выводим способ вывода
    printf("\tSnapshot in binary form:\n");
    // Выводим начало первой линии
    printf("\t%d: ", line++);
    // Перебор байтов слепка ПК
    for (i = 0; i < snapshot.size; ++i) {
        // Если количество напечатаных байт 16, то выводим начало следующей линии
        if (!(i & 15) && i != 0)
            printf("\n\t%d: ", line++);

        // Выводим элемент слепка ПК в бинарном формате
        printf("%x ", snapshot.ptr[i]);
    }

    // Выводим символ перевода на следующую строку
    printf("\n");
}

/**************************************************************************
 * Функция вывода на экран слепка ПК в виде строки                        *
 **************************************************************************/
void printSnapshotString(const rtfl_utils_PcSnapshot snapshot) {
    uint8_t i = 0;
    // Выводим способ вывода
    printf("\tSnapshot as string: ");
    // Перебор байтов слепка ПК
    for (i = 0; i < snapshot.size; ++i) {
        // Выводим байты слепка ПК в виде строки
        printf("%c", snapshot.ptr[i]);
    }

    // Выводим символ перевода на следующую строку
    printf("\n");
}

/**************************************************************************
 * Функция вывода на экран слепка ПК в разных форматах                    *
 **************************************************************************/
void printSnapshot(const rtfl_utils_PcSnapshot snapshot) {
    // Выводим поясняющее сообщение
    printf("Display PC snapshot in different forms:\n");
    // Выводим слепок ПК в виде строки
    printSnapshotString(snapshot);
    // Выводим символ перевода на следующую строку
    printf("\n");
    // Выводим слепок ПК в бинарном формате
    printSnapshotHex(snapshot);
}

int main(void) {
    int exitCode = EXIT_FAILURE;
    rtfl_utils_PcSnapshot snapshot = { 0 }; // Слепок ПК

    // Вычисляем слепок ПК
    UTILS_ST_OK_CHECK(rtfl_utils_pc_snapshot(&snapshot), cleanup);

    // Выводим вычисленный слепок ПК в терминал
    printSnapshot(snapshot);

    // Успешно завершаем работу программы
    exitCode = EXIT_SUCCESS;

cleanup:
    if (snapshot.ptr != RTFLASH_NULL_PTR) {
        rtfl_utils_StatusCode stCode = rtfl_utils_pc_snapshot_destroy(&snapshot);
        if (stCode != RTFL_UTILS_ST_OK) {
            printf("Cleanup error: rtfl_utils_pc_snapshot_destroy status code: %u\n", stCode);
            exitCode = EXIT_FAILURE;
        } else {
            snapshot = (rtfl_utils_PcSnapshot){ 0 };
        }
    }
    printf("Cleanup finished.\n");
    if (exitCode == EXIT_SUCCESS)
        printf("Sample completed successfully!\n");
    return exitCode;
}