#!/usr/bin/env bash

set -eu

# Параметры домена
ALDPRO_SERVER="dc.ald2.test"
ALDPRO_SERVER_IP="172.16.112.13"
DOMAIN="ald2.test"
ALDPRO_ADMIN="admin"
ALDPRO_ADMIN_PASSWORD="Eklmn1516"
ALDPRO_VERSION="2.1.0"

# Проверка на наличие root-прав
[[ "$(whoami)" != "root" ]] && \
    echo "Скрипт должен быть запущен с root-правами" && \
    exit 1

# Проверка на корректный hostname
[[ "$(hostname -s)" == "localhost" ]] && \
    echo "Недопустимо использовать localhost в качестве hostname" && \
    echo "Измените его при помощи вызова команды 'hostnamectl set-hostname <hostname>'" && \
    exit 1

[[ "$(hostname -s)" =~ [A-Z] ]] && \
    echo "Недопустимо наличие символов в верхнем регистре в hostname" && \
    echo "Измените его при помощи вызова команды 'hostnamectl set-hostname <hostname>'" && \
    exit 1

set -x

# Добавление репозиториев Ald Pro
echo -e "deb https://dl.astralinux.ru/aldpro/stable/repository-main/ $ALDPRO_VERSION main" > /etc/apt/sources.list.d/aldpro.list
echo -e "deb https://dl.astralinux.ru/aldpro/stable/repository-extended/ generic main" >> /etc/apt/sources.list.d/aldpro.list

# Установка необходимых пакетов
apt-get update
DEBIAN_FRONTEND=noninteractive apt-get install -q -y aldpro-client

# Изменение hostname машины
hostnamectl set-hostname "$(hostname -s).$DOMAIN"

# Настройка разрешения имён
MACHINE_IP=$(hostname -I | grep -Eo '^([0-9]+\.){3}[0-9]+')
sed -i "s/127.0.1.1.*/$MACHINE_IP $(hostname -s).$DOMAIN/" /etc/hosts
echo "$ALDPRO_SERVER_IP $ALDPRO_SERVER ${ALDPRO_SERVER%%.*}" >> /etc/hosts

# Настройка сетевого соединения
CON_NAME="$(nmcli -t -f NAME c show --active | head -n 1 -)"
nmcli con mod "$CON_NAME" ipv4.dns "$ALDPRO_SERVER_IP"
nmcli con mod "$CON_NAME" ipv4.ignore-auto-dns yes
nmcli con down "$CON_NAME"; nmcli con up "$CON_NAME"

# Ввод клиента в домен
/opt/rbta/aldpro/client/bin/aldpro-client-installer -c "$DOMAIN" -u "$ALDPRO_ADMIN" -p "$ALDPRO_ADMIN_PASSWORD" -d "$(hostname -s)" -i -f

set +x

# Напоминание о необходимости перезагрузить систему
echo "Перезагрузите систему"