#!/usr/bin/env bash

set -eu

# Параметры домена
SERVER_IP="172.16.112.240"
DOMAIN="smbrtkn.test"
ADMIN_USERNAME="cadmin"
BIOS_NAME="SMBRTKN"

ADMIN_PASSWORD="Eklmn1516"

# Проверка на наличие root-прав
[[ "$(whoami)" != "root" ]] && \
    echo "Скрипт должен быть запущен с root-правами" && \
    exit 1

# Проверка на корректный hostname
[[ "$(hostname -s)" == "localhost" ]] && \
    echo "Недопустимо использовать localhost в качестве hostname" && \
    echo "Измените его при помощи вызова команды 'hostnamectl set-hostname <hostname>'" && \
    exit 1

set -x

# Установка необходимых пакетов
apt-get update
DEBIAN_FRONTEND=noninteractive apt-get install -q -y astra-ad-sssd-client

# Изменение hostname машины
hostnamectl set-hostname "$(hostname -s).$DOMAIN"

# Настройка сетевого соединения
CON_NAME="$(nmcli -t -f NAME c show --active | head -n 1 -)"
nmcli con mod "$CON_NAME" ipv4.dns "$SERVER_IP"
nmcli con mod "$CON_NAME" ipv4.ignore-auto-dns yes
nmcli con down "$CON_NAME"; nmcli con up "$CON_NAME"

# Ввод клиента в домен
astra-ad-sssd-client -d "$DOMAIN" -u "$ADMIN_USERNAME" -p "$ADMIN_PASSWORD" -y

# Настройка kerberos
sed -i '/^\[libdefaults\]/a dns_lookup_realm = False' /etc/krb5.conf
sed -i '/^\[libdefaults\]/a dns_lookup_kdc = True' /etc/krb5.conf

set +x

# Напоминание о необходимости перезагрузить систему
echo "Перезагрузите систему"
