#!/usr/bin/env bash

set -eu

# Параметры домена
SERVER_IP="172.16.112.140"
DOMAIN="smbtest.test"
ADMIN_USERNAME="login"
ADMIN_PASSWORD="password"

# Проверка на наличие root-прав
[[ "$(whoami)" != "root" ]] && \
    echo "Скрипт должен быть запущен с root-правами" && \
    exit 1

# Проверка на корректный hostname
[[ "$(hostname -s)" == "localhost" ]] && \
    echo "Недопустимо использовать localhost в качестве hostname" && \
    echo "Измените его при помощи вызова команды 'hostnamectl set-hostname <hostname>'" && \
    exit 1

set -x

# Установка необходимых пакетов
dnf install -y join-to-domain openssh-clients samba samba-common

# Изменение hostname машины
hostnamectl set-hostname "$(hostname -s).$DOMAIN"

# Настройка разрешения имён
echo "$SERVER_IP $DOMAIN" >> /etc/hosts

# Настройка сетевого соединения
CON_NAME="$(nmcli -t -f NAME c show --active | head -n 1 -)"
nmcli con mod "$CON_NAME" ipv4.dns "$SERVER_IP,8.8.8.8"
nmcli con mod "$CON_NAME" ipv4.ignore-auto-dns yes
nmcli con down "$CON_NAME"; nmcli con up "$CON_NAME"

# Ввод клиента в домен
join-to-domain.sh -d "$DOMAIN" -n "$(hostname -s)" -u "$ADMIN_USERNAME" -p "$ADMIN_PASSWORD" -y

set +x

# Напоминание о необходимости перезагрузить систему
echo "При успешном вводе клиента в домен перезагрузите систему"
